/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.AutomaticDependencies;
import org.netbeans.core.startup.CoreBridge;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ManifestSection;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbStartStop;
import org.netbeans.core.startup.layers.ModuleLayeredFileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.ModuleInstall;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.SharedClassObject;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;

final class NbInstaller
extends ModuleInstaller {
    private static final Logger LOG = Logger.getLogger(NbInstaller.class.getName());
    private final Map<Module, Set<ManifestSection>> sections = new HashMap<Module, Set<ManifestSection>>(100);
    private final Map<Module, Class<? extends ModuleInstall>> installs = new HashMap<Module, Class<? extends ModuleInstall>>(100);
    private final Map<Module, String> layers = new HashMap<Module, String>(100);
    private boolean initializedFolderLookup = false;
    private final Events ev;
    private ModuleList moduleList;
    private ModuleManager mgr;
    private final Map<Module, Set<String>> kosherPackages = new HashMap<Module, Set<String>>(100);
    private final Map<Module, List<Module.PackageExport>> hiddenClasspathPackages = new HashMap<Module, List<Module.PackageExport>>();
    private final Map<Module.PackageExport, List<Module>> hiddenClasspathPackagesReverse = new HashMap<Module.PackageExport, List<Module>>();
    private final Cache cache = new Cache();
    private final NbStartStop onStartStop = new NbStartStop(null, null);
    private final InstanceContent.Convertor<ManifestSection, Object> convertor = new Convertor();
    private static String cacheCnb;
    private static Set<Dependency> cacheDeps;
    private static final String[] CLASSPATH_PACKAGES;
    private static final String[][] CLASSPATH_JARS;

    public NbInstaller(Events events) {
        this.ev = events;
    }

    void registerList(ModuleList moduleList) {
        if (this.moduleList != null) {
            throw new IllegalStateException();
        }
        this.moduleList = moduleList;
    }

    void registerManager(ModuleManager moduleManager) {
        if (this.mgr != null) {
            throw new IllegalStateException();
        }
        this.mgr = moduleManager;
    }

    public void prepare(Module module) throws InvalidException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.ev.log("prepare", new Object[]{module});
        this.checkForHiddenPackages(module);
        HashSet<InvalidException> hashSet = null;
        Class<?> clazz = null;
        String string = this.cache.findGlobalProperty("processSections", null, "false");
        if (!"false".equals(string)) {
            object4 = module.getManifest();
            if (object4 == null) {
                throw new InvalidException(module, "no manifest");
            }
            object3 = ((Manifest)object4).getEntries().entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = ManifestSection.create((String)object2.getKey(), (Attributes)object2.getValue(), module);
                if (object == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<InvalidException>(25);
                }
                hashSet.add((InvalidException)((Object)object));
            }
            if (hashSet != null) {
                this.cache.findGlobalProperty("processSections", "false", "true");
            }
        }
        if ((object4 = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Install", false)) != null) {
            try {
                object3 = Util.createPackageName((String)object4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = new InvalidException(module, illegalArgumentException.toString());
                object.initCause((Throwable)illegalArgumentException);
                throw object;
            }
            if (((String)object4).endsWith(".ser")) {
                throw new InvalidException(module, "Serialized module installs not supported: " + (String)object4);
            }
            try {
                clazz = Class.forName((String)object3, false, module.getClassLoader());
                if (clazz.getClassLoader() != module.getClassLoader()) {
                    this.ev.log("wrongClassLoader", new Object[]{module, clazz, module.getClassLoader()});
                }
                for (object2 = clazz; object2 != ModuleInstall.class && object2 != Object.class; object2 = ((Class)object2).getSuperclass()) {
                    try {
                        ((Class)object2).getDeclaredMethod("validate", new Class[0]);
                        object = (ModuleInstall)SharedClassObject.findObject(clazz.asSubclass(ModuleInstall.class), (boolean)true);
                        object.validate();
                        continue;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (object2 == Object.class) {
                    throw new ClassCastException("Should extend ModuleInstall: " + clazz.getName());
                }
            }
            catch (Exception exception) {
                object = new InvalidException(module, exception.toString());
                object.initCause((Throwable)exception);
                throw object;
            }
            catch (LinkageError linkageError) {
                object = new InvalidException(module, linkageError.toString());
                object.initCause((Throwable)linkageError);
                throw object;
            }
        }
        if ((object3 = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Layer", false)) != null && !module.isNetigso() && (object2 = module.getClassLoader().getResource((String)object3)) == null) {
            throw new InvalidException(module, "Layer not found: " + (String)object3);
        }
        object2 = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Description", false);
        if (object2 != null) {
            Util.err.log(Level.WARNING, "Use of OpenIDE-Module-Description in {0} is deprecated.", module.getCodeNameBase());
            Util.err.warning("(Please install help using an XML layer instead.)");
        }
        if (hashSet != null) {
            this.sections.put(module, (Set<ManifestSection>)hashSet);
        }
        if (clazz != null) {
            this.installs.put(module, clazz.asSubclass(ModuleInstall.class));
        }
        if (object3 != null) {
            this.layers.put(module, (String)object3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForHiddenPackages(Module module) throws InvalidException {
        ArrayList<Module.PackageExport> arrayList = new ArrayList<Module.PackageExport>();
        LinkedList<Module> linkedList = new LinkedList<Module>();
        linkedList.add(module);
        for (Object object : module.getDependencies()) {
            if (object.getType() != 1) continue;
            Module string4 = this.mgr.get((String)Util.parseCodeName((String)object.getName())[0]);
            assert (string4 != null) : object;
            linkedList.add(string4);
        }
        for (Object object : linkedList) {
            String string = this.cache.findProperty((ModuleInfo)object, "OpenIDE-Module-Hide-Classpath-Packages", false);
            if (string == null) continue;
            for (String string2 : string.trim().split("[ ,]+")) {
                try {
                    String string3;
                    if (string2.endsWith(".*")) {
                        string3 = string2.substring(0, string2.length() - 2);
                        Dependency.create((int)1, (String)string3);
                        if (string3.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                        }
                        arrayList.add(new Module.PackageExport(string3.replace('.', '/') + '/', false));
                        continue;
                    }
                    if (string2.endsWith(".**")) {
                        string3 = string2.substring(0, string2.length() - 3);
                        Dependency.create((int)1, (String)string3);
                        if (string3.lastIndexOf(47) != -1) {
                            throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                        }
                        arrayList.add(new Module.PackageExport(string3.replace('.', '/') + '/', true));
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal OpenIDE-Module-Hide-Classpath-Packages: " + string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidException((Module)object, illegalArgumentException.getMessage());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
            synchronized (map) {
                this.hiddenClasspathPackages.put(module, arrayList);
                for (Module.PackageExport packageExport : arrayList) {
                    Object object = this.hiddenClasspathPackagesReverse.get(packageExport);
                    if (object == null) {
                        object = new LinkedList();
                        this.hiddenClasspathPackagesReverse.put(packageExport, (List<Module>)object);
                    }
                    object.add(module);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(Module module) {
        Util.err.fine("dispose: " + module);
        Set<ManifestSection> set = this.sections.remove(module);
        if (set != null) {
            for (ManifestSection object : set) {
                object.dispose();
            }
        }
        this.installs.remove(module);
        this.layers.remove(module);
        this.kosherPackages.remove(module);
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            this.hiddenClasspathPackages.remove(module);
            for (List<Module> list : this.hiddenClasspathPackagesReverse.values()) {
                list.remove(module);
            }
        }
    }

    protected void classLoaderUp(ClassLoader classLoader) {
        MainLookup.systemClassLoaderChanged(classLoader);
        this.ev.log("perfTick", new Object[]{"META-INF/services/ additions registered"});
    }

    final void waitOnStart() {
        this.onStartStop.waitOnStart();
    }

    public void load(final List<Module> list) {
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                NbInstaller.this.loadImpl(list);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImpl(List<Module> list) {
        this.ev.log("startLoad", new Object[]{list});
        this.checkForDeprecations(list);
        this.loadLayers(list, true);
        this.ev.log("perfTick", new Object[]{"layers loaded"});
        this.onStartStop.initialize();
        this.ev.log("perfTick", new Object[]{"@OnStart"});
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - sections"});
        this.ev.log("loadSection", new Object[0]);
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, true);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
                this.ev.log("perfTick", new Object[]{"sections for " + module.getCodeName() + " loaded"});
            }
        }
        finally {
            CoreBridge.getDefault().loaderPoolTransaction(false);
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - sections"});
        if (!this.initializedFolderLookup) {
            Util.err.fine("modulesClassPathInitialized");
            MainLookup.modulesClassPathInitialized();
            this.initializedFolderLookup = true;
        }
        Main.initUICustomizations();
        this.ev.log("perfStart", new Object[]{"NbInstaller.load - ModuleInstalls"});
        for (Module module : list) {
            try {
                this.loadCode(module, true);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
            catch (AssertionError assertionError) {
                Util.err.log(Level.SEVERE, null, (Throwable)((Object)assertionError));
            }
            this.ev.log("perfTick", new Object[]{"ModuleInstall for " + module.getCodeName() + " called"});
        }
        this.ev.log("perfEnd", new Object[]{"NbInstaller.load - ModuleInstalls"});
        this.ev.log("finishLoad", new Object[]{list});
        if (Boolean.getBoolean("netbeans.preresolve.classes")) {
            this.preresolveClasses(list);
        }
    }

    final void preloadCache(Collection<Module> collection) {
        for (Module module : collection) {
            this.isShowInAutoUpdateClient((ModuleInfo)module);
        }
    }

    public void unload(final List<Module> list) {
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            @Override
            public void run() {
                NbInstaller.this.unloadImpl(list);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadImpl(List<Module> list) {
        this.ev.log("startUnload", new Object[]{list});
        for (Module module : list) {
            try {
                this.loadCode(module, false);
            }
            catch (Exception exception) {
                Util.err.log(Level.SEVERE, null, exception);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        CoreBridge.getDefault().loaderPoolTransaction(true);
        try {
            for (Module module : list) {
                try {
                    this.loadSections(module, false);
                }
                catch (Exception exception) {
                    Util.err.log(Level.SEVERE, null, exception);
                }
                catch (LinkageError linkageError) {
                    Util.err.log(Level.SEVERE, null, linkageError);
                }
            }
        }
        finally {
            try {
                CoreBridge.getDefault().loaderPoolTransaction(false);
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
        }
        this.loadLayers(list, false);
        this.ev.log("finishUnload", new Object[]{list});
    }

    private void loadCode(Module module, boolean bl) throws Exception {
        Class<? extends ModuleInstall> clazz = this.installs.get(module);
        if (clazz != null) {
            ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
            if (bl) {
                this.ev.log("restore", new Object[]{module});
                moduleInstall.restored();
            } else {
                this.ev.log("uninstall", new Object[]{module});
                moduleInstall.uninstalled();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSections(Module module, boolean bl) throws Exception {
        Set<ManifestSection> set = this.sections.get(module);
        if (set == null) {
            return;
        }
        boolean bl2 = false;
        try {
            this.ev.log("loadSection", new Object[0]);
            for (ManifestSection manifestSection : set) {
                if (manifestSection instanceof ManifestSection.ActionSection) {
                    if (!bl2) {
                        Object object = module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
                        if (object == null) {
                            object = module.getCodeNameBase();
                        }
                        CoreBridge.getDefault().attachToCategory(object);
                        bl2 = true;
                    }
                    CoreBridge.getDefault().loadActionSection((ManifestSection.ActionSection)manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.ClipboardConvertorSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.DebuggerSection) {
                    this.loadGenericSection(manifestSection, bl);
                    continue;
                }
                if (manifestSection instanceof ManifestSection.LoaderSection) {
                    CoreBridge.getDefault().loadLoaderSection((ManifestSection.LoaderSection)manifestSection, bl);
                    continue;
                }
                assert (false) : manifestSection;
            }
        }
        finally {
            if (bl2) {
                CoreBridge.getDefault().attachToCategory(null);
            }
        }
    }

    private void loadGenericSection(ManifestSection manifestSection, boolean bl) {
        CoreBridge.getDefault().loadDefaultSection(manifestSection, this.convertor, bl);
    }

    void loadLayers(List<Module> list, boolean bl) {
        LinkedHashSet<URL> linkedHashSet;
        ModuleLayeredFileSystem moduleLayeredFileSystem;
        this.ev.log(bl ? "loadLayers" : "unloadLayers", new Object[]{list});
        list = new ArrayList<Module>(list);
        Collections.reverse(list);
        HashMap hashMap = new HashMap(5);
        ModuleLayeredFileSystem moduleLayeredFileSystem2 = ModuleLayeredFileSystem.getUserModuleLayer();
        ModuleLayeredFileSystem moduleLayeredFileSystem3 = ModuleLayeredFileSystem.getInstallationModuleLayer();
        hashMap.put(moduleLayeredFileSystem2, new LinkedHashSet(1000));
        hashMap.put(moduleLayeredFileSystem3, new LinkedHashSet(1000));
        for (Module object : list) {
            Object object2;
            Object object3;
            String string;
            moduleLayeredFileSystem = object.isReloadable() ? moduleLayeredFileSystem2 : moduleLayeredFileSystem3;
            linkedHashSet = (LinkedHashSet<URL>)hashMap.get((Object)moduleLayeredFileSystem);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet<URL>(1000);
                hashMap.put(moduleLayeredFileSystem, linkedHashSet);
            }
            if ((string = this.layers.get(object)) != null) {
                Util.err.log(Level.FINE, "loadLayer: {0} load={1}", new Object[]{string, bl});
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    object3 = string;
                    object2 = "";
                } else {
                    object3 = string.substring(0, n);
                    object2 = string.substring(n);
                }
                boolean bl2 = false;
                for (String string2 : NbCollections.iterable((Iterator)NbBundle.getLocalizingSuffixes())) {
                    String string3 = (String)object3 + string2 + (String)object2;
                    Enumeration enumeration = object.findResources(string3);
                    if (!enumeration.hasMoreElements()) continue;
                    URL uRL = (URL)enumeration.nextElement();
                    assert (!enumeration.hasMoreElements()) : "At most one resource per module: " + object;
                    linkedHashSet.add(uRL);
                    bl2 = true;
                }
                if (!bl2) {
                    Util.err.fine("Module layer not found: " + string);
                    continue;
                }
            }
            object3 = object.findResources("META-INF/generated-layer.xml");
            while (object3.hasMoreElements()) {
                object2 = (URL)object3.nextElement();
                linkedHashSet.add((URL)object2);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            moduleLayeredFileSystem = (ModuleLayeredFileSystem)((Object)entry.getKey());
            linkedHashSet = (Collection)entry.getValue();
            Util.err.log(Level.FINE, "Adding/removing layer URLs: host={0} urls={1}", new Object[]{moduleLayeredFileSystem, linkedHashSet});
            try {
                if (bl) {
                    moduleLayeredFileSystem.addURLs(linkedHashSet);
                    continue;
                }
                moduleLayeredFileSystem2.removeURLs(linkedHashSet);
                moduleLayeredFileSystem3.removeURLs(linkedHashSet);
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
            }
        }
    }

    private void checkForDeprecations(List<Module> list) {
        TreeSet<String> treeSet;
        String string;
        String string2;
        TreeMap<String, TreeSet<String>> treeMap = new TreeMap<String, TreeSet<String>>();
        for (Module object : list) {
            string2 = this.cache.findProperty((ModuleInfo)object, "OpenIDE-Module-Deprecated", false);
            if (Boolean.parseBoolean(string2)) continue;
            for (Object object2 : object.getDependencies()) {
                if (object2.getType() != 1) continue;
                string = (String)Util.parseCodeName((String)object2.getName())[0];
                treeSet = (TreeSet<String>)treeMap.get(string);
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    treeMap.put(string, treeSet);
                }
                treeSet.add(object.getCodeNameBase());
            }
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            Object object2;
            string2 = (String)entry.getKey();
            Module module = this.mgr.get(string2);
            assert (module != null) : "No such module: " + string2;
            object2 = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Deprecated", false);
            if (!Boolean.parseBoolean((String)object2)) continue;
            string = this.cache.findProperty((ModuleInfo)module, "OpenIDE-Module-Deprecation-Message", true);
            treeSet = (Set)entry.getValue();
            if (string != null) {
                Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated: {2}", new Object[]{treeSet, string2, string});
                continue;
            }
            Util.err.log(Level.WARNING, "the modules {0} use {1} which is deprecated.", new Object[]{treeSet, string2});
        }
    }

    public boolean closing(List<Module> list) {
        Util.err.fine("closing: " + list);
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall moduleInstall = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (moduleInstall.closing()) continue;
                Util.err.fine("Module " + module + " refused to close");
                return false;
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.SEVERE, null, runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.SEVERE, null, linkageError);
            }
        }
        return this.onStartStop.closing(list);
    }

    public void close(List<Module> list) {
        Util.err.fine("close: " + list);
        this.ev.log("close", new Object[0]);
        this.moduleList.shutDown();
        List<Task> list2 = this.onStartStop.startClose(list);
        for (Module module : list) {
            Class<? extends ModuleInstall> clazz = this.installs.get(module);
            if (clazz == null) continue;
            try {
                ModuleInstall throwable = (ModuleInstall)SharedClassObject.findObject(clazz, (boolean)true);
                if (throwable == null) {
                    throw new IllegalStateException("Inconsistent state: " + clazz);
                }
                throwable.close();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Util.err.log(Level.SEVERE, null, throwable);
            }
        }
        for (Task task : list2) {
            task.waitFinished();
        }
    }

    protected Set<Dependency> loadDependencies(String string) {
        return string.equals(cacheCnb) ? cacheDeps : null;
    }

    static void register(String string, Object object) {
        cacheCnb = string;
        cacheDeps = (Set)object;
    }

    public void refineDependencies(Module module, Set<Dependency> set) {
        if (Boolean.getBoolean("org.netbeans.core.modules.NbInstaller.noAutoDeps")) {
            return;
        }
        AutomaticDependencies.Report report = AutomaticDependencies.getDefault().refineDependenciesAndReport(module.getCodeNameBase(), set);
        if (report.isModified()) {
            Util.err.warning(report.toString());
        }
    }

    public String[] refineProvides(Module module) {
        if (module.getCodeNameBase().equals("org.openide.modules")) {
            ArrayList<String> arrayList = new ArrayList<String>(4);
            CoreBridge.defineOsTokens(arrayList);
            arrayList.add("org.openide.modules.ModuleFormat1");
            arrayList.add("org.openide.modules.ModuleFormat2");
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        if (module2 == null) {
            List<Module.PackageExport> list;
            for (String string2 : CLASSPATH_PACKAGES) {
                if (!string.startsWith(string2) || this.findKosher(module).contains(string2)) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Refusing to load classpath package " + string + " for " + module.getCodeNameBase() + " without a proper dependency");
                }
                return false;
            }
            Object object = this.hiddenClasspathPackages;
            synchronized (object) {
                list = this.hiddenClasspathPackages.get(module);
            }
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    Module.PackageExport packageExport = (Module.PackageExport)object.next();
                    if (!(packageExport.recursive ? string.startsWith(packageExport.pkg) : string.equals(packageExport.pkg))) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + string + " for " + module.getCodeNameBase());
                    }
                    return false;
                }
            }
            if (!this.checkBootDelegation(string)) {
                return false;
            }
        }
        if (LOG.isLoggable(Level.FINER) && !string.equals("java/util/logging/")) {
            LOG.finer("Delegating resource " + string + " from " + module2 + " for " + module.getCodeNameBase());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldDelegateClasspathResource(String string) {
        Map<Module, List<Module.PackageExport>> map = this.hiddenClasspathPackages;
        synchronized (map) {
            for (Map.Entry<Module.PackageExport, List<Module>> entry : this.hiddenClasspathPackagesReverse.entrySet()) {
                Module.PackageExport packageExport = entry.getKey();
                if (!(packageExport.recursive ? string.startsWith(packageExport.pkg) : string.equals(packageExport.pkg))) continue;
                for (Module module : entry.getValue()) {
                    if (!module.isEnabled()) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Refusing to load classpath package " + string + " because of " + module.getCodeNameBase());
                    }
                    return false;
                }
            }
        }
        return this.checkBootDelegation(string);
    }

    private boolean checkBootDelegation(String string) {
        String string2 = System.getProperty("netbeans.bootdelegation");
        if (string2 != null && !string.startsWith("java/")) {
            boolean bl = false;
            for (String string3 : string2.split(",")) {
                if ((string3 = string3.trim()).endsWith(".*")) {
                    if (!string.startsWith(string3 = string3.substring(0, string3.length() - 2).replace('.', '/') + '/') || string.length() <= string3.length()) continue;
                    bl = true;
                    break;
                }
                if (!string.equals(string3 = string3.replace('.', '/') + '/')) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        return true;
    }

    private Set<String> findKosher(Module module) {
        Set<String> set = this.kosherPackages.get(module);
        if (set == null) {
            set = new HashSet<String>();
            Set set2 = module.getDependencies();
            SpecificationVersion specificationVersion = Util.getModuleDep((Set)set2, (String)"org.openide");
            boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
            for (Dependency dependency : set2) {
                String string;
                String string2;
                if (dependency.getType() == 1 && dependency.getName().equals("org.netbeans.core.startup/1")) {
                    set.add("org/netbeans/core/startup/");
                    continue;
                }
                if (bl && dependency.getType() == 1) {
                    Module module2;
                    string2 = dependency.getName();
                    int n = string2.indexOf(47);
                    if (n != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if ((module2 = this.mgr.get(string2)) == null) {
                        throw new IllegalStateException("Should have found dep " + dependency + " from " + module);
                    }
                    set.addAll(this.findKosher(module2));
                    continue;
                }
                if (dependency.getType() != 2) continue;
                string2 = dependency.getName();
                int n = string2.indexOf(91);
                if (n == -1) {
                    string = string2.replace('.', '/').concat("/");
                } else if (n == 0) {
                    int n2 = string2.lastIndexOf(46);
                    string = string2.substring(1, n2).replace('.', '/').concat("/");
                } else {
                    string = string2.substring(0, n).replace('.', '/').concat("/");
                }
                for (String string3 : CLASSPATH_PACKAGES) {
                    if (!string.startsWith(string3)) continue;
                    set.add(string3);
                }
            }
            if (set.isEmpty()) {
                set = Collections.emptySet();
            }
            this.kosherPackages.put(module, set);
        }
        return set;
    }

    String getEffectiveClasspath(Module module) {
        if (!module.isEnabled()) {
            return "";
        }
        ArrayList<String> arrayList = new ArrayList<String>(100);
        NbInstaller.createBootClassPath(arrayList);
        Set<String> set = module.isFixed() ? null : this.findKosher(module);
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        stringTokenizer = new StringTokenizer(System.getProperty("netbeans.dynamic.classpath", ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NbInstaller.addStartupClasspathEntry(new File(stringTokenizer.nextToken()), arrayList, set);
        }
        HashSet<Module> hashSet = new HashSet<Module>(50);
        HashSet<String> hashSet2 = new HashSet<String>(10);
        for (Dependency dependency : module.getDependencies()) {
            if (dependency.getType() != 1 || dependency.getComparison() != 2) continue;
            hashSet2.add(dependency.getName());
        }
        SpecificationVersion specificationVersion = Util.getModuleDep((Set)module.getDependencies(), (String)"org.openide");
        boolean bl = specificationVersion == null || specificationVersion.compareTo((Object)new SpecificationVersion("1.3.12")) < 0;
        this.addModuleClasspathEntries(module, module, hashSet, hashSet2, arrayList, bl ? Integer.MAX_VALUE : 1);
        StringBuilder stringBuilder = new StringBuilder(arrayList.size() * 100 + 1);
        for (String string : arrayList) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static void createBootClassPath(List<String> list) {
        Object object;
        String string = System.getProperty("sun.boot.class.path");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                list.add(((StringTokenizer)object).nextToken());
            }
        }
        if ((object = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)object, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                File[] fileArray = file.listFiles();
                if (fileArray == null) continue;
                for (File file2 : fileArray) {
                    String string2 = file2.getName().toLowerCase(Locale.US);
                    if (!string2.endsWith(".zip") && !string2.endsWith(".jar")) continue;
                    list.add(file2.getAbsolutePath());
                }
            }
        }
    }

    private static void addStartupClasspathEntry(File file, List<String> list, Set<String> set) {
        if (file.isDirectory()) {
            list.add(file.getAbsolutePath());
            return;
        }
        String string = file.getName();
        for (String[] stringArray : CLASSPATH_JARS) {
            if (set == null || !string.startsWith(stringArray[0])) continue;
            StringBuilder stringBuilder = null;
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!set.contains(string2)) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(100);
                    stringBuilder.append(file.getAbsolutePath());
                    stringBuilder.append('[');
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string2.replace('/', '.'));
                stringBuilder.append("**");
            }
            if (stringBuilder != null) {
                stringBuilder.append(']');
                list.add(stringBuilder.toString());
            }
            return;
        }
        list.add(file.getAbsolutePath());
    }

    private void addModuleClasspathEntries(Module module, Module module2, Set<Module> set, Set<String> set2, List<String> list, int n) {
        Object object;
        String string;
        Module.PackageExport[] packageExportArray2;
        if (!set.add(module)) {
            return;
        }
        for (Module.PackageExport[] packageExportArray2 : module.getDependencies()) {
            if (packageExportArray2.getType() != 1) continue;
            string = (String)Util.parseCodeName((String)packageExportArray2.getName())[0];
            object = this.mgr.get(string);
            if (object == null) {
                throw new IllegalStateException("No such module: " + string);
            }
            if (n <= 0) continue;
            this.addModuleClasspathEntries((Module)object, module2, set, set2, list, n - 1);
        }
        boolean bl = module == module2 || set2.contains(module.getCodeName());
        packageExportArray2 = bl ? null : module.getPublicPackages();
        string = "";
        if (packageExportArray2 != null) {
            if (packageExportArray2.length == 0) {
                return;
            }
            object = new StringBuilder(100);
            ((StringBuilder)object).append('[');
            for (int i = 0; i < packageExportArray2.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)object).append(',');
                }
                ((StringBuilder)object).append(packageExportArray2[i].pkg.replace('/', '.'));
                ((StringBuilder)object).append(packageExportArray2[i].recursive ? "**" : "*");
            }
            ((StringBuilder)object).append(']');
            string = ((StringBuilder)object).toString();
        }
        for (File file : module.getAllJars()) {
            list.add(file.getAbsolutePath() + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preresolveClasses(List<Module> list) {
        Util.err.info("Pre-resolving classes for all loaded modules...be sure you have not specified -J-Xverify:none in ide.cfg");
        for (Module module : list) {
            if (module.isFixed() || module.getJarFile() == null) continue;
            File file = module.getJarFile();
            try {
                JarFile jarFile = new JarFile(file, true);
                try {
                    for (JarEntry jarEntry : NbCollections.iterable(jarFile.entries())) {
                        String string = jarEntry.getName();
                        if (!string.endsWith(".class")) continue;
                        String string2 = string.substring(0, string.length() - 6).replace('/', '.');
                        Throwable throwable = null;
                        try {
                            Class.forName(string2, false, module.getClassLoader());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throwable = classNotFoundException;
                        }
                        catch (LinkageError linkageError) {
                            throwable = linkageError;
                        }
                        catch (RuntimeException runtimeException) {
                            throwable = runtimeException;
                        }
                        if (throwable == null) continue;
                        Util.err.log(Level.WARNING, "From " + string2 + " in " + module.getCodeNameBase() + " with effective classpath " + this.getEffectiveClasspath(module), throwable);
                    }
                }
                finally {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                Util.err.log(Level.WARNING, null, iOException);
            }
        }
    }

    final boolean isShowInAutoUpdateClient(ModuleInfo moduleInfo) {
        String string = this.cache.findProperty(moduleInfo, "AutoUpdate-Show-In-Client", false);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        if (moduleInfo instanceof Module) {
            return !((Module)moduleInfo).isNetigso();
        }
        return true;
    }

    static {
        CLASSPATH_PACKAGES = new String[]{"org/netbeans/core/startup/"};
        CLASSPATH_JARS = new String[][]{{"core", "org/netbeans/core/", "org/netbeans/beaninfo/"}, {"boot"}};
    }

    static class Cache
    implements Stamps.Updater {
        private static final String CACHE = "all-installer.dat";
        private final boolean modulePropertiesCached;
        private final Properties moduleProperties;

        public Cache() {
            block3: {
                InputStream inputStream = Stamps.getModulesJARs().asStream(CACHE);
                if (inputStream != null) {
                    Properties properties = new Properties();
                    try {
                        properties.load(inputStream);
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        LOG.log(Level.INFO, "Can't load all-installer.dat", iOException);
                        break block3;
                    }
                    this.moduleProperties = properties;
                    this.modulePropertiesCached = true;
                    return;
                }
            }
            this.moduleProperties = new Properties();
            this.modulePropertiesCached = false;
        }

        final String findProperty(ModuleInfo moduleInfo, String string, boolean bl) {
            String string2;
            Object object;
            String string3 = moduleInfo.getCodeNameBase() + '.' + string;
            if (this.modulePropertiesCached) {
                object = this.moduleProperties.getProperty(string3);
                if ("\u0000".equals(object)) {
                    return null;
                }
                if (object != null) {
                    return object;
                }
                LOG.log(Level.FINE, "not cached value: {0} for {1}", new Object[]{string, moduleInfo});
            }
            Object object2 = object = bl ? moduleInfo.getLocalizedAttribute(string) : moduleInfo.getAttribute(string);
            if (object == null) {
                this.moduleProperties.setProperty(string3, "\u0000");
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
                return null;
            }
            String string4 = string2 = object instanceof String ? (String)object : null;
            if (string2 != null) {
                this.moduleProperties.setProperty(string3, string2);
                Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
            }
            return string2;
        }

        final String findGlobalProperty(String string, String string2, String string3) {
            assert (string != null);
            assert (string3 != null);
            if (this.modulePropertiesCached) {
                return this.moduleProperties.getProperty(string);
            }
            Object object = this.moduleProperties.get(string);
            if (Utilities.compareObjects((Object)string2, (Object)object)) {
                this.moduleProperties.put(string, string3);
            }
            Stamps.getModulesJARs().scheduleSave((Stamps.Updater)this, CACHE, false);
            return null;
        }

        public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
            this.moduleProperties.store(dataOutputStream, null);
        }

        public void cacheReady() {
        }
    }

    private final class Convertor
    implements InstanceContent.Convertor<ManifestSection, Object> {
        Convertor() {
        }

        public Object convert(ManifestSection manifestSection) {
            try {
                return manifestSection.getInstance();
            }
            catch (Exception exception) {
                Util.err.log(Level.WARNING, null, exception);
                NbInstaller.this.loadGenericSection(manifestSection, false);
                return null;
            }
        }

        public Class<?> type(ManifestSection manifestSection) {
            return manifestSection.getSuperclass();
        }

        public String id(ManifestSection manifestSection) {
            return manifestSection.toString();
        }

        public String displayName(ManifestSection manifestSection) {
            return manifestSection.toString();
        }
    }
}

